﻿#python

# File: connect_weight_skeleton.py
# Author: Satoshi Sawada (Blog : http://www.modonote.com/)
# Description: If same name, conncect weight map to skeleton.
# Version: 1.0(2014-07-15)

import sys
import lx

#################################################################
#	Main function
#################################################################

### Get Skeleton and GenInfluence Information ###

# get item number in current scene
item_num = lx.eval( "query sceneservice item.N ?" )

#lx.out( "item_num = %s" % item_num )

# locator_names : locator display name
#			ex: Skeleton_Joint, Skeleton_Joint (2), ...
# locator_ids : locator internal name
#			ex : locator022, locator024, ...
locator_names = []
locator_ids = [] 

# mesh_names : mesh display name
# mesh_ids : mesh internal name
mesh_names = []
mesh_ids = []

# scan all items in scene
for i in range( 0, item_num ):
	
	# Get item's display name, type, internal name, tagType
	com_string = "query sceneservice item.name ? " + str( i )
	item_name = lx.eval( com_string )
	com_string = "query sceneservice item.type ? " + str( i )
	item_type = lx.eval( com_string )
	#lx.out( "item_type = %s" % item_type )
	com_string = "query sceneservice item.id ? " + str( i )
	item_id = lx.eval( com_string )
	com_string = "query sceneservice item.tagTypes ? " + str( i )
	item_tag = lx.eval( com_string )
	
	if( item_type == "locator" ):
		
		# Get locator display names and internal names in scene
		locator_names.append( item_name )
		locator_ids.append( item_id )
		#lx.out( "locator number = %d" % len( locator_names ) )
		lx.out( "locator name = %s" % locator_names )
		#lx.out( "locator id = %s" % locator_ids )
	
	elif( item_type == "mesh" ):
		
		# Get mesh display names and  internal names in scene
		mesh_names.append( item_name )
		mesh_ids.append( item_id )
	


### Get Weight Information ###
weight_num = lx.eval( "query layerservice vmap.N ? weight" )
lx.out( "weight number = %d" % weight_num )

if weight_num != 0:
	
	# Create Weight Map Name Lists
	wgt_maps = lx.eval( "query layerservice vmaps ? weight" )
	wgt_names = []
	
	for each_map in wgt_maps:
		
		com_string = "query layerservice vmap.type ? " + each_map
		map_type = lx.eval( com_string )
		lx.out( "map_type = %s" % map_type )
		
		com_string = "query layerservice vmap.name ? " + each_map
		map_name = lx.eval( com_string )
		wgt_names.append( map_name )
		
		lx.out( "map_name = %s" % map_name )
		


### Connect Weight to Skeleton ###
if locator_names != 0:
	
	i = 0
	for sk_name in locator_names:
		# Select Mesh
		lx.eval( "select.subItem " + mesh_ids[ 0 ] + " set mesh;camera;light;txtrLocator;backdrop;groupLocator;replicator;surfGen;locator;deform;locdeform;deformGroup;deformMDD2;morphDeform;itemInfluence;genInfluence;deform.wrap;softLag;ABCdeform.sample;chanModify;defaultShader;defaultShader 0 0" )
		
		sk_id = locator_ids[ i ]
		i += 1
		
		# Deformer Name from Skeleton
		# if same name, use the weight
		for wgt_name in wgt_names:
			if( sk_name == wgt_name ):
				# Create Deformer to Mesh
				lx.eval( "item.addDeformer genInfluence" )
				lx.eval( 'select.deformer "General Influence" set' )
				lx.eval( 'item.name "def_' + sk_name + '" genInfluence' )
				deformer_name = 'def_' + sk_name
				
				# Deformer Type Weightmap
				lx.eval( "item.channel genInfluence$type mapWeight" )
				com_string = 'genInfluence.name "' +  wgt_name + '"'
				lx.eval( com_string )
				
				# Link skeleton and deformer
				lx.eval( "item.link $infeff " + sk_id + " " + deformer_name + " posT:0 replace:false" )
				lx.out( "item.link: %s" % sk_id )
				lx.out( "and: %s"  % deformer_name )

