﻿#python

# File: vmap_renamer.py
# Author: Satoshi Sawada (Blog : http://www.modonote.com/)
# Description: Vertex map rename a selection item.
# Version: 1.0(2014-07-15) Weightmap Support


import sys
import lx
import re

#################################################################
# Form
#################################################################
testSearch = lx.eval( "user.value vmap_renamer.search ?" )
textReplace = lx.eval( "user.value vmap_renamer.replace ?" )


#################################################################
#	Main function
#################################################################
if len(testSearch) != 0:
	### Get Weight Information ###
	weight_num = lx.eval( "query layerservice vmap.N ? weight" )
	#lx.out( "weight number = %d" % weight_num )

	if weight_num != 0:
		
		## Create Weight Map Name Lists
		wgt_maps = lx.eval( "query layerservice vmaps ? weight" )
		wgt_names = []
		
		for each_map in wgt_maps:
			
			com_string = "query layerservice vmap.type ? " + each_map
			map_type = lx.eval( com_string )
			#lx.out( "map_type = %s" % map_type )
			
			com_string = "query layerservice vmap.name ? " + each_map
			map_name = lx.eval( com_string )
			wgt_names.append( map_name )
			
			#lx.out( "map_name = %s" % map_name )
		
		
		## Rename Map
		for pre_map_name in wgt_names:
			
			com_string = "select.vertexMap " + pre_map_name + " wght replace"
			lx.eval( com_string )
			
			new_map_name = pre_map_name.replace( testSearch, textReplace )
			#lx.out( "new_map_name = %s" % new_map_name )
			
			com_string = "vertMap.name " + new_map_name + " wght active"
			lx.eval( com_string )
		
